﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista order entity.
    /// </summary>
    [Serializable]
    public class Order : IEntity
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Order"/> class.
        /// </summary>
        public Order()
        {
            OrdersOrderableItems = new List<OrdersOrderableItem>();
        }

        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the object of order.
        /// </summary>
        /// <value>
        /// The object of order.
        /// </value>
        public string ObjectOfOrder { get; set; }

        /// <summary>
        /// Gets or sets the date of last activity.
        /// </summary>
        /// <value>
        /// The date of last activity.
        /// </value>
        public DateTime? DateOfLastActivity { get; set; }

        /// <summary>
        /// Gets or sets the order status id.
        /// </summary>
        /// <value>
        /// The order status id.
        /// </value>
        public int? OrderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the patient location id (IEN).
        /// </summary>
        /// <value>
        /// The patient location id.
        /// </value>
        public string PatientLocationId { get; set; }

        /// <summary>
        /// Gets or sets the item ordered.
        /// </summary>
        /// <value>
        /// The item ordered.
        /// </value>
        public string ItemOrdered { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the stop date.
        /// </summary>
        /// <value>
        /// The stop date.
        /// </value>
        public DateTime? StopDate { get; set; }

        /// <summary>
        /// Gets or sets the dc date time.
        /// </summary>
        /// <value>
        /// The dc date time.
        /// </value>
        public DateTime? DcDateTime { get; set; }

        /// <summary>
        /// Gets or sets to display group id.
        /// </summary>
        /// <value>
        /// To display group id.
        /// </value>
        public int? ToDisplayGroupId { get; set; }

        /// <summary>
        /// Gets or sets the orders orderable item.
        /// </summary>
        /// <value>
        /// The orders orderable item.
        /// </value>
        public IList<OrdersOrderableItem> OrdersOrderableItems { get; set; }

        /// <summary>
        /// Gets or sets the order status.
        /// </summary>
        /// <value>
        /// The order status.
        /// </value>
        public OrderStatus OrderStatus { get; set; }

        /// <summary>
        /// Gets or sets the order action.
        /// </summary>
        /// <value>
        /// The order action.
        /// </value>
        public OrderAction OrderAction { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        public Patient Patient { get; set; }


    }
}
